/*
 * If distributed as part of the Linux kernel, this code is licensed under the
 * terms of the GPL v2.
 *
 * Otherwise, the following license terms apply:
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1) Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2) Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3) The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESSED OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */
#ifndef _DEV_PCI_FCUREG_H_
#define	_DEV_PCI_FCUREG_H_


/*
 * PCI base address register
 */
#define FBI_PCI_IOBA	0x10
#define FBI_PCI_MMBA	0x14


/*
 * I/O register offset
 */
#define FBI_OFS_IO_BYTELANE		(0x00000000)	/* W */
#define FBI_OFS_IO_INTRCTL		(0x00000004)	/* W */
#define FBI_OFS_IO_INTRCAUSE	(0x00000008)	/* R */
#define FBI_OFS_IO_RESETCTL		(0x0000000c)	/* R/W */
#define FBI_OFS_IO_DMACTL		(0x00000010)	/* R/W */
#define FBI_OFS_IO_DMAMODE		(0x00000014)	/* R/W */
#define FBI_OFS_IO_DMAINTRCLR	(0x00000018)	/* W */
#define FBI_OFS_IO_SCANENDCMD	(0x0000001c)	/* W */
#define FBI_OFS_IO_DMA1ADDR		(0x00000020)	/* W */
#define FBI_OFS_IO_DMA2ADDR		(0x00000024)	/* W */
#define FBI_OFS_IO_DMA3ADDR		(0x00000028)	/* W */
#define FBI_OFS_IO_DMA4ADDR		(0x0000002c)	/* W */
#define FBI_OFS_IO_DMA1SIZE		(0x00000030)	/* R/W */
#define FBI_OFS_IO_DMA2SIZE		(0x00000034)	/* R/W */
#define FBI_OFS_IO_DMA3SIZE		(0x00000038)	/* R/W */
#define FBI_OFS_IO_DMA4SIZE		(0x0000003c)	/* R/W */


/*
 * I/O register bit asign
 */
/* FBI_OFS_IO_BYTELANE */
#define FBI_BIT_BYTELANE_TARGET	(0x00000001)	/* TARGETがLITTLEに見える */
#define FBI_BIT_BYTELANE_DPRAM	(0x00000002)	/* DPRAMがLITTLEに見える */
/* FBI_OFS_IO_INTRCTL */
#define FBI_BIT_INTRCTL_INTR	(0x00000001)	/* 割込み発生 */
#define FBI_BIT_INTRCTL_INTRCLR	(0x00000002)	/* 割込みクリア */
/* FBI_OFS_IO_INTRCAUSE */
#define FBI_BIT_INTRCAUSE_DPRAM	(0x00000001)	/* 要因:DPRAM割込み */
#define FBI_BIT_INTRCAUSE_TO_DP	(0x00000002)	/* FACEでDPRAM割込み発生中 */
#define FBI_BIT_INTRCAUSE_DMA1	(0x00000004)	/* 要因:DMA1 割込み */
#define FBI_BIT_INTRCAUSE_DMA2	(0x00000008)	/* 要因:DMA2 割込み */
#define FBI_BIT_INTRCAUSE_DMA3A	(0x00000010)	/* 要因:DMA3A割込み */
#define FBI_BIT_INTRCAUSE_DMA4A	(0x00000020)	/* 要因:DMA4A割込み */
#define FBI_BIT_INTRCAUSE_DMA3B	(0x00000040)	/* 要因:DMA3B割込み */
#define FBI_BIT_INTRCAUSE_DMA4B	(0x00000080)	/* 要因:DMA4B割込み */
#define FBI_BIT_INTRCAUSE_DMALL	(0x000000fc)	/* 要因:DMA割込み全部 */
#define FBI_BIT_INTRCAUSE_ALL	(0x000000ff)	/* 要因:割込み全部 */
/* FBI_OFS_IO_RESETCTL */
#define FBI_BIT_RESETCTL_PCIRDY	(0x00000001)	/* PCIバス側レディ */
#define FBI_BIT_RESETCTL_FCURDY	(0x00000002)	/* FACE側レディ */
/* FBI_OFS_IO_DMACTL */
#define FBI_BIT_DMACTL_DMA1		(0x00000001)	/* DMA1 :動作中(R)/停止(W) */
#define FBI_BIT_DMACTL_DMA2		(0x00000002)	/* DMA2 :動作中(R)/停止(W) */
#define FBI_BIT_DMACTL_DMA3A	(0x00000004)	/* DMA3A:動作中(R)/停止(W) */
#define FBI_BIT_DMACTL_DMA4A	(0x00000008)	/* DMA4A:動作中(R)/停止(W) */
#define FBI_BIT_DMACTL_DMAALL	(0x0000000f)	/* DMA1-4:停止(W) */
#define FBI_BIT_DMACTL_DMA3B	(0x00000010)	/* DMA3B:動作中(R)/停止(W) */
#define FBI_BIT_DMACTL_DMA4B	(0x00000020)	/* DMA4B:動作中(R)/停止(W) */
#define FBI_BIT_DMACTL_DMA3BUF	(0x00000040)	/* DMA3:バッファが空でない */
#define FBI_BIT_DMACTL_DMA3FULL	(0x00000080)	/* DMA3:バッファがフル */
#define FBI_BIT_DMACTL_DMA4BUF	(0x00000100)	/* DMA4:バッファが空でない */
#define FBI_BIT_DMACTL_DMA4FULL	(0x00000200)	/* DMA4:バッファがフル */
#define FBI_BIT_DMACTL_DMA1RDY	(0x00000400)	/* DMA1:FIFOに空きがある */
#define FBI_BIT_DMACTL_DMA2RDY	(0x00000800)	/* DMA2:FIFOにデータがある */
/* FBI_OFS_IO_DMAMODE */
#define FBI_BIT_DMAMODE_D1_ENA	(0x00000001)	/* DMA1 :割込みenable */
#define FBI_BIT_DMAMODE_D2_ENA	(0x00000002)	/* DMA2 :割込みenable */
#define FBI_BIT_DMAMODE_D3AENA	(0x00000004)	/* DMA3A:割込みenable */
#define FBI_BIT_DMAMODE_D4AENA	(0x00000008)	/* DMA4A:割込みenable */
#define FBI_BIT_DMAMODE_D3BENA	(0x00000010)	/* DMA3B:割込みenable */
#define FBI_BIT_DMAMODE_D4BENA	(0x00000020)	/* DMA4B:割込みenable */
#define FBI_BIT_DMAMODE_DALL	(0x0000003f)	/* DMAALL:割込みenable */
#define FBI_BIT_DMAMODE_D3_1234	(0x00000000)	/* (00)DMA3:バイトレーン1234 */
#define FBI_BIT_DMAMODE_D3_3412	(0x00000040)	/* (01)DMA3:バイトレーン3412 */
#define FBI_BIT_DMAMODE_D3_2143	(0x00000080)	/* (10)DMA3:バイトレーン2143 */
#define FBI_BIT_DMAMODE_D3_4321	(0x000000c0)	/* (11)DMA3:バイトレーン4321 */
#define FBI_BIT_DMAMODE_D3_MASK	(0x000000c0)	/* DMA3:バイトレーンマスク */
#define FBI_BIT_DMAMODE_D4_1234	(0x00000000)	/* (00)DMA4:バイトレーン1234 */
#define FBI_BIT_DMAMODE_D4_3412	(0x00000100)	/* (01)DMA4:バイトレーン3412 */
#define FBI_BIT_DMAMODE_D4_2143	(0x00000200)	/* (10)DMA4:バイトレーン2143 */
#define FBI_BIT_DMAMODE_D4_4321	(0x00000300)	/* (11)DMA4:バイトレーン4321 */
#define FBI_BIT_DMAMODE_D4_MASK	(0x00000300)	/* DMA4:バイトレーンマスク */
/* FBI_OFS_IO_DMAINTRCLR */
#define FBI_BIT_DMAINTRCLR_D1	(0x00000001)	/* DMA1 :割込みクリア */
#define FBI_BIT_DMAINTRCLR_D2	(0x00000002)	/* DMA2 :割込みクリア */
#define FBI_BIT_DMAINTRCLR_D3A	(0x00000004)	/* DMA3A:割込みクリア */
#define FBI_BIT_DMAINTRCLR_D4A	(0x00000008)	/* DMA4A:割込みクリア */
#define FBI_BIT_DMAINTRCLR_D3B	(0x00000010)	/* DMA3B:割込みクリア */
#define FBI_BIT_DMAINTRCLR_D4B	(0x00000020)	/* DMA4B:割込みクリア */
#define FBI_BIT_DMAINTRCLR_DALL	(0xffffffff)	/* 全ch割込みクリア */
/* FBI_OFS_IO_DMA[1|2|3|4]ADDR */
#define FBI_BIT_DMAADDR_MASK	(~0x00000003)	/* DMA1-4:アドレスマスク */
/* FBI_OFS_IO_DMA[1|2]SIZE */
#define FBI_BIT_DMA12WIDTH_MASK	(0x000000ff)	/* DMA1,2の幅マスク */
#define FBI_BIT_DMA12LINE_MASK	(0x0007ffff)	/* DMA1,2のライン数マスク */
#define FBI_SHIFT_DMA12SIZE		(8)				/* DMA1,2のライン数シフト */
#define FBI_BIT_DMA34SIZE_MASK	(0x07ffffff)	/* DMA3,4のサイズ数マスク */


/*
 * memory register offset
 */
#define FBI_OFS_MM_DPRAM_BASE	(0x00000000)	/* R/W */
#define FBI_OFS_MM_DMA1_BASE	(0x00000800)	/* W */
#define FBI_OFS_MM_DMA2_BASE	(0x00001000)	/* R */
#define FBI_OFS_MM_DMA3_BASE	(0x00001800)	/* R/W */
#define FBI_OFS_MM_DMA4_BASE	(0x00001c00)	/* R/W */
#define FBI_OFS_MM_END			(0x00002000)	/* dummy */
/* memory size */
#define FBI_MM_DPRAM_SIZE		(FBI_OFS_MM_DMA1_BASE - FBI_OFS_MM_DPRAM_BASE)
#define FBI_MM_DMA1_SIZE		(FBI_OFS_MM_DMA2_BASE - FBI_OFS_MM_DMA1_BASE)
#define FBI_MM_DMA2_SIZE		(FBI_OFS_MM_DMA3_BASE - FBI_OFS_MM_DMA2_BASE)
#define FBI_MM_DMA3_SIZE		(FBI_OFS_MM_DMA4_BASE - FBI_OFS_MM_DMA3_BASE)
#define FBI_MM_DMA4_SIZE		(FBI_OFS_MM_END       - FBI_OFS_MM_DMA4_BASE)


#endif	/* !_DEV_PCI_FCUREG_H_ */
